/*
  ------------------- lcdfuncs.h -------------------
  low level functions for controlling the lcd screen
*/

#define LCD_WIDTH            40
#define LCD_HEIGHT            4

#define LCD_GRAPHIC_WIDTH    23
#define LCD_GRAPHIC_HEIGHT   38

/* initialize the lcd subsystem, call this once when you program starts up */
/* custom_mode = 0 for bars, custom_mode = 1 for graphic display */
void lcd_init(char custom_mode);

/* release resources */
void lcd_uninit(void);

/* clear the lcd */
void lcd_clear(void);

/* redraw the lcd, use this if it gets corrupted */
void lcd_redraw(void);

/* disable or enable the lcd, data is kept and writes are allowed when disabled */
/* t = 0 -> turn off, t = 1 -> turn on */
void lcd_onoff(char t);

/* place a string of text on the screen starting at row/col */
/* row is 0..LCD_HEIGHT, col is 0..LCD_WIDTH-1 */
int __attribute__ ((format(printf, 6, 7)))
     lcd_printf(int row, int col, int max_length, int min_length, int flush,
                const char *format, ...);

void lcd_flush(void);

/*
 * if custom_mode == 0
 * place a bar on the screen starting at row/col with size wide and value val
 * row is 0..LCD_HEIGHT, col is 0..LCD_WIDTH-1, wide is 1..LCD_WIDTH, val is 0..5*wide
 */
void lcd_putbar (int row, int col, int wide, short val, int flush);

/*
 * if custom_mode == 1
 * define the place on the screen for a graphic starting at col, size is 4x4 chars
 * col is 0..LCD_WIDTH-4
 */
void lcd_locategraphic (int col);

/*
 * if custom_mode == 1
 * place graphic data on the screen of size LCD_GRAPHIC_WIDTH bits wide by
 * LCD_GRAPHIC_HEIGHT bits high
 * data is a pointer to LCD_GRAPHIC_HEIGHT longwords containing LCD_GRAPHIC_WIDTH
 * bits of data each.
 */
void lcd_updategraphic (long *data);

/* print stastistics to the screen.  existing data is saved and restored 10 seconds later */
void lcd_printstats (void);


/* end of file */
