
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/io.h>
#include <sys/time.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#ifdef SOEKRIS
#include <linux/net4801gpio.h>

#define GPIO_DEV "/dev/gpio0"
#define REG_CONTROL_RS   0x01
#define REG_CONTROL_E2   0x02
#define REG_CONTROL_E1   0x04
#define REG_CONTROL_RW   0x08

#else
#include <linux/ppdev.h>

#define GPIO_DEV "/dev/parport0"
#define REG_CONTROL_E1   0x01
#define REG_CONTROL_E2   0x02
#define REG_CONTROL_RS   0x04
#define REG_CONTROL_RW   0

#endif

int main (int argc, char *argv[])
{
  int gpio_dev_fd;
  
#ifdef SOEKRIS
  int arg;
  
  /* Open GPIO device */
  gpio_dev_fd = open(GPIO_DEV, O_RDWR);
  if (gpio_dev_fd < 0)
    {
      perror("cant open gpio device");
      exit(1);
    }
  
  if (ioctl(gpio_dev_fd, GPIORDNUMPINS, &arg) < 0)
    {
      perror("cant get numpins");
      exit(1);
    }
  if (arg < 8)
    {
      fprintf(stderr,"not enough pins, only %d\n", arg);
      exit(1);
    }
  
  /* set all pins to output */
  arg = 0xFF;
  if (ioctl(gpio_dev_fd, GPIOWRDIRECTION, &arg) < 0)
    {
      perror("cant set direction");
      exit(1);
    }
  
  if (argc == 2)
    {
      int reg;
      
      reg = strtoul(argv[1],NULL,0);
      
      if (ioctl(gpio_dev_fd, GPIOWRDATA, &reg) < 0)
        {
          perror("cant set data");
          exit(1);
        }
    }
#else

  gpio_dev_fd = open(GPIO_DEV, O_RDWR);
  if (gpio_dev_fd < 0)
    {
      perror("Cannot open " GPIO_DEV);
      exit(1);
    }
  
  if (ioctl(gpio_dev_fd, PPCLAIM, NULL) < 0)
    {
      perror("cannot claim pport");
      exit(1);
    }
  
  if (argc == 3)
    {
      int data, control;
      
      data = strtoul(argv[1],NULL,0);
      control = strtoul(argv[2],NULL,0);
      
      if (ioctl(gpio_dev_fd, PPWDATA, &data) < 0)
        {
          perror("cant set control reg");
          exit(1);
        }
      
      /* E1 and E2 are inverted */
      data ^= REG_CONTROL_E1 | REG_CONTROL_E2;
      data |= 0x08;
      data &= 0x0F;
      
      if (ioctl(gpio_dev_fd, PPWCONTROL, &control) < 0)
        {
          perror("cant set control reg");
          exit(1);
        }
    }

  if (ioctl(gpio_dev_fd, PPRELEASE, NULL) < 0)
    {
      perror("cannot release pport");
      exit(1);
    }
  
#endif
  close(gpio_dev_fd);
  exit(0);
}


/* end of file */
