/*
  ------------------- lcdtest.c -------------------
  main program to test the lcd screen
*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "lcdfuncs.h"

static void lcd_diag_showcharacters(int offset)
{
  int i;
  
  lcd_clear();
  lcd_onoff(0);
  lcd_printf(0, 0, LCD_WIDTH, 0, 0,
             "Showing Character Set 0x%2.2X...0x%2.2X  ", offset, offset+63);
  lcd_printf(2, 0, LCD_WIDTH, 0, 0, "0x%2.2X:", offset);
  lcd_printf(3, 0, LCD_WIDTH, 0, 0, "0x%2.2X:", offset+32);
  
  for (i=0; i<32; i++)
    {
      if ((i%16)<10)
        {
          lcd_printf(1, i+6, LCD_WIDTH, 0, 0, "%c", ((unsigned char)i%16) + '0');
        }
      else
        {
          lcd_printf(1, i+6, LCD_WIDTH, 0, 0, "%c", ((unsigned char)i%16) + 'A' - 10);
        }
      lcd_printf(2, i+6, LCD_WIDTH, 0, 0, "%c", (unsigned char)i + 0 + offset);
      lcd_printf(3, i+6, LCD_WIDTH, 0, 0, "%c", (unsigned char)i + 32 + offset);
    }
  lcd_flush();
  lcd_onoff(1);
}

static void lcd_diag_torture(void)
{
  int i, j, k;
  char a = 0;
  
  lcd_clear();
  
  for (j=0; j<LCD_HEIGHT; j++)
    {
      for (k=0; k<LCD_WIDTH; k+=10)
        {
          lcd_printf(j, k, LCD_WIDTH, 0, 0, "|");
        }
    }
  lcd_flush();
  
  for (i=0; i<256*8; i++)
    {
      for (j=0; j<LCD_HEIGHT; j++)
        {
          for (k=0; k<LCD_WIDTH; k++)
            {
              if (k%10)
                {
                  lcd_printf(j, k, LCD_WIDTH, 0, 0, "%c", a);
                }
            }
        }
      lcd_flush();
      a++;
    }
  
}

static void lcd_diag_showbar(int count)
{
  int i,j;
  for (j=0; j<count; j++)
    {
      for (i=20*5;i>=0;i--)
        {
          lcd_putbar(0, 0, 5,i/4, 1);
          lcd_putbar(0, 5, 5,i/4, 1);
          lcd_putbar(0,10, 5,i/4, 1);
          lcd_putbar(0,15, 5,i/4, 1);
          lcd_putbar(0,20, 5,i/4, 1);
          lcd_putbar(0,25, 5,i/4, 1);
          lcd_putbar(0,30, 5,i/4, 1);
          lcd_putbar(0,35, 5,i/4, 1);
          lcd_putbar(1, 0,10,i/2, 1);
          lcd_putbar(1,10,10,i/2, 1);
          lcd_putbar(1,20,10,i/2, 1);
          lcd_putbar(1,30,10,i/2, 1);
          lcd_putbar(2, 0,20,i, 1);
          lcd_putbar(2,20,20,i, 1);
          lcd_putbar(3, 0,40,i*2, 1);
          usleep(10000);
        }
    }
}


static void lcd_diag_showgraphic(void)
{
  int i, offset;
  long data[LCD_GRAPHIC_HEIGHT];
  
  memset(data,0,sizeof(data));
  
  for (offset=0; offset<LCD_WIDTH; offset+=4)
    { 
      lcd_locategraphic(offset);
    }
  
  for (offset=0; offset<(LCD_GRAPHIC_HEIGHT*6); offset++)
    {
      for (i=0; i<LCD_GRAPHIC_HEIGHT; i++)
	{
	  data[i] =
	    (1 << ((i+ 0+offset)%LCD_GRAPHIC_WIDTH)) |
	    (1 << ((i+ 1+offset)%LCD_GRAPHIC_WIDTH)) |
	    (1 << ((i+ 2+offset)%LCD_GRAPHIC_WIDTH)) |
	    (1 << ((i+ 3+offset)%LCD_GRAPHIC_WIDTH)) |
	    (1 << ((i+ 4+offset)%LCD_GRAPHIC_WIDTH)) |
	    (1 << ((i+ 5+offset)%LCD_GRAPHIC_WIDTH)) |
	    (1 << ((i+ 6+offset)%LCD_GRAPHIC_WIDTH)) |
	    (1 << ((i+ 7+offset)%LCD_GRAPHIC_WIDTH)) ;
	}
      lcd_updategraphic(data);
      usleep(10*1000);
    }
  
}

#define NUM_DIAGS 8

static void lcd_diag (char which)
{
  
  switch (which)
    {
    case 0:
      lcd_init(0);
      break;
      
    case 1:
    case 2:
    case 3:
    case 4:
      printf("Showing characters %d..%d\n", (which-1)*64, (which*64)-1);
      lcd_init(0);
      lcd_diag_showcharacters(64*(which-1));
      sleep(2);
      break;
      
    case 5:
      printf("Showing bar\n");
      lcd_init(0);
      lcd_diag_showbar(3);
      break;
      
    case 6:
      printf("Showing graphic\n");
      lcd_init(1);
      lcd_diag_showgraphic();
      break;
      
    case 7:
      printf("Running Torture Test\n");
      lcd_init(0);
      lcd_diag_torture();
      break;
      
    default:
      break;
    }
}


int main(int argc, char *argv[])
{
  
  if (argc > 1)
    {
      int test = atoi(argv[1]);
      lcd_diag(test);
    }
  else
    {
      int diag;
      for (diag=0; diag<NUM_DIAGS; diag++)
        {
          lcd_diag(diag);
        }
    }
  
  lcd_uninit();
  return(0);
}

/* end of file */

