/*
  ------------------ lcdwork2.c -------------------
*/

#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/sysinfo.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#define WAITTIME 50
#define MAX_MESSAGE_SIZE 1000
#define MESSAGE_GAP "  \x7F \x7E  "
#define MESSAGE_WINDOW 40


#include "lcdfuncs.h"

/* functions */
static void initscreen(const char *phone, const char *name);
static char* gettime(char *str, time_t when);
static char* gettime_long(char *str, time_t when);
static void blink(int on);

static void gobackground(void);
static void gotusr1(int);
static void gotusr2(int);

/* vars */
static int needsredraw = 0;
static int needsstat = 0;

static int set_nonblocking(int fd, int nonblock)
{
  long current;
  
  current = fcntl(fd, F_GETFL, 0);
  
  if (current == -1)
    {
      return -1;
    }
  
  if (nonblock)
    return fcntl(fd, F_SETFL, current | O_NONBLOCK);
  else
    return fcntl(fd, F_SETFL, current & ~O_NONBLOCK);
}


int main(int argc, char *argv[])
{
  struct timeval lasttv = {};
  struct timeval lastsubtv = {};
  time_t last_here = 0;
  int opt;
  const char *status_file = NULL;
  char status_message[MAX_MESSAGE_SIZE+sizeof(MESSAGE_GAP)+1] = {};
  int status_message_offset = 0;
  int status_message_changed = 0;
  time_t status_file_mtime = 0;
  unsigned long int last_kbms = 0;
  char str50[50] = {};
  const char *phone = "\?\?\?-\?\?\?-\?\?\?\?";
  const char *name = "xxxxxxxxxxxx";
  int gone_long = 6*60;
  int input_fd = -1;
  
  chdir("/");
  
  while ( (opt = getopt(argc, argv, "bf:p:n:g:i:")) != -1 )
    {
      switch (opt)
        {
        case 'b':
          gobackground();
          break;
          
        case 'f':
          status_file = optarg;
          break;
          
        case 'p':
          phone = optarg;
          break;
          
        case 'n':
          name = optarg;
          break;
          
        case 'g':
          gone_long = strtoul(optarg, NULL, 0) * 60;
          break;
          
        case 'i':
          if (input_fd < 0)
            {
              input_fd = open(optarg, O_RDONLY);
              if (input_fd < 0)
                {
                  perror(optarg);
                }
              else
                {
                  if (set_nonblocking(input_fd, 1) < 0)
                    {
                      perror(optarg);
                      close(input_fd);
                      input_fd = -1;
                    }
                }
            }
          break;
          
        default:
          break;
        }
    }
  
  signal(SIGUSR1,gotusr1);
  signal(SIGUSR2,gotusr2);
  
  initscreen(phone,name);
  
  while (1)
    {
      struct timeval thistv;
      int changesec;
      int changesubsec;
      
      gettimeofday(&thistv, NULL);
      
      if (lasttv.tv_sec != thistv.tv_sec)
        {
          changesec=1;
        }
      else
        {
          changesec=0;
        }
      
      if (!lastsubtv.tv_sec || ((((thistv.tv_sec - lastsubtv.tv_sec) * 1000) + ((thistv.tv_usec/1000) - (lastsubtv.tv_usec/1000))) > 250))
        {
          lastsubtv = thistv;
          changesubsec = 1;
        }
      else
        {
          changesubsec = 0;
        }
      
      lasttv = thistv;
      
      /* handle signals */
      if (needsredraw)
        {
          needsredraw=0;
          lcd_redraw();
        }
      
      if (needsstat)
        {
          needsstat=0;
          lcd_printstats();
	}
      
#if 1
      /* every 60 seconds */
      if (changesec && !(thistv.tv_sec%60))
        {
         needsredraw=1;
        }
#endif
      
      /* every 5 seconds */
      if (changesec && !(thistv.tv_sec%5))
        {
          time_t gone;
          
          /* check idle */
          
          if (input_fd < 0)
            {
              FILE *fptr;
              fptr = fopen("/proc/interrupts", "r");
              if (fptr == NULL)
                {
                  lcd_printf(2, 11, LCD_WIDTH, 0, 1, "/proc/interrupts: %s", strerror(errno));
                }
              else
                {
                  unsigned long cur;
                  unsigned long cur_kbms = 0;
                  char buffer[100];
                  while (fgets(buffer, 100, fptr) != NULL)
                    {
                      if (strstr(buffer,"keyboard") &&
                          (sscanf(buffer, "%*d: %lu", &cur) == 1))
                        {
                          cur_kbms += cur;
                        }
                      else if (strstr(buffer,"ouse") &&
                               (sscanf(buffer, "%*d: %lu", &cur) == 1))
                        {
                          cur_kbms += cur;
                        }
                    }
                  
                  fclose(fptr);
                  
                  if (last_kbms != cur_kbms)
                    {
                      last_kbms = cur_kbms;
                      last_here = thistv.tv_sec;
                    }
                }
            }
          else
            {
              char buffer[1024];
              while (read(input_fd, buffer, sizeof(buffer)) > 0)
                {
                  last_here = thistv.tv_sec;
                }
            }
          
          gone = thistv.tv_sec - last_here;
          gone /= 60;
              
          if (!gone)
            {
              lcd_printf(2, 0, LCD_WIDTH, LCD_WIDTH, 0, "            \x7E\x7E I'm Here! \x7F\x7F");
            }
          else if (gone > gone_long)
            {
              lcd_printf(2, 0, LCD_WIDTH, LCD_WIDTH, 0, "                           ");
            }
          else if (gone < 60)
            {
              gettime_long(str50,last_here);
              lcd_printf(2, 0, LCD_WIDTH, 24, 0, "Last Here: %s", str50);
              lcd_printf(2, 25, LCD_WIDTH, 15, 0, "    Gone %lumin", gone);
            }
          else if (gone < 60*24)
            {
              gettime_long(str50,last_here);
              lcd_printf(2, 0, LCD_WIDTH, 24, 0, "Last Here: %s", str50);
              lcd_printf(2, 25, LCD_WIDTH, 15, 0, "Gone %luhr %lumin",
                         gone / 60,
                         gone % 60);
            }
          else
            {
              gettime_long(str50,last_here);
              lcd_printf(2, 0, LCD_WIDTH, 24, 0, "Last Here: %s", str50);
              lcd_printf(2, 25, LCD_WIDTH, 15, 0, "Gone %luday %luhr",
                         gone / 60 / 24,
                         (gone / 60) % 24);
                }
          lcd_flush();
        }
      
      /* every second */
      if (changesec)
        {
          
          /* time */
          gettime(str50,thistv.tv_sec);
          lcd_printf(0, 23, LCD_WIDTH, 0, 1, str50);
          
          blink(thistv.tv_sec%2);
        }
      
      if (status_file)
        {
          int length;
          
          if (changesec)
            {
              struct stat sbuf;
              
              if (stat(status_file, &sbuf) < 0)
                {
                  snprintf(status_message, MAX_MESSAGE_SIZE, "stat(%s): %s",
                           status_file, strerror(errno));
                  status_message_changed = 1;
                }
              else if (status_file_mtime != sbuf.st_mtime)
                {
                  int fd;
                  
                  fd = open(status_file,O_RDONLY);
                  
                  if (fd < 0)
                    {
                      snprintf(status_message, MAX_MESSAGE_SIZE, "open(%s): %s",
                               status_file, strerror(errno));
                      status_message_changed = 1;
                    }
                  else
                    {
                      int ret;
                      
                      ret = read(fd, &status_message, MAX_MESSAGE_SIZE);
                      if (ret < 0)
                        {
                          snprintf(status_message, MAX_MESSAGE_SIZE, "open(%s): %s",
                                   status_file, strerror(errno));
                          status_message_changed = 1;
                        }
                      else
                        {
                          if (status_message[ret-1] == '\n')
                            {
                              status_message[ret-1] = '\0';
                            }
                          
                          if (!status_message[0])
                            {
                              snprintf(status_message, MAX_MESSAGE_SIZE, "<no note set>");
                            }
                          
                          status_message_changed = 1;
                          status_file_mtime = sbuf.st_mtime;
                        }
                      close(fd);
                    }
                }
              
            }
          
          if (changesubsec)
            {
              length = strlen(status_message);
              
              if (length <= MESSAGE_WINDOW)
                {
                  if (status_message_changed)
                    {
                      lcd_printf(1, 0, LCD_WIDTH, MESSAGE_WINDOW, 0, " ");
                      lcd_printf(1, (MESSAGE_WINDOW-length)/2, LCD_WIDTH, 0, 0, status_message);
                      lcd_flush();
                      status_message_changed = 0;
                    }
                }
              else
                {
                  if (status_message_changed)
                    {
                      status_message_offset = 0;
                      snprintf(status_message+length, sizeof(MESSAGE_GAP),
                               "%s", MESSAGE_GAP);
                      length += sizeof(MESSAGE_GAP);
                      status_message_changed = 0;
                    }
                  
                  /* print first */
                  lcd_printf(1, 0, LCD_WIDTH, MESSAGE_WINDOW, 0, status_message + status_message_offset);
                  
                  if ((length - status_message_offset) < MESSAGE_WINDOW)
                    {
                      /* print second */
                      lcd_printf(1, (length - status_message_offset), LCD_WIDTH, MESSAGE_WINDOW - (length - status_message_offset), 0, status_message);
                    }
                  lcd_flush();
                  
                  status_message_offset++;
                  status_message_offset %= length;
                }
            }
        }
      
      /* sleep */
      usleep(WAITTIME*1000);
      
    }
}

static void initscreen(const char *phone, const char *name)
{
  lcd_init(0);
  
  /* setup display   "-123456789-123456789-123456789-123456789" */
  lcd_printf(0, 0, LCD_WIDTH, 0, 1, "xx    %12s      x xx xx xx    xx", name);
  lcd_printf(1, 0, LCD_WIDTH, 0, 1, "                                        ");
  lcd_printf(2, 0, LCD_WIDTH, 0, 1, "                                        ");
  lcd_printf(3, 0, LCD_WIDTH, 0, 1, "xx Gone?  E-Mail or Call %12s xx", phone);
  
  return;
}

static char* gettime_long(char *str, time_t when)
{
  strftime (str, 40, "%a %I:%M %p", localtime(&when));
  return str;
}

static char* gettime(char *str, time_t when)
{
  strftime (str, 40, "%l:%M:%S %p", localtime(&when));
  return str;
}


static void blink(int on)
{
  const char *ss;
  
  ss = on ? "\xFF\xFF" : "==";
  
  lcd_printf(0, 0,  LCD_WIDTH, 0, 1, ss);
  lcd_printf(0, 38, LCD_WIDTH, 0, 1, ss);
  lcd_printf(3, 0,  LCD_WIDTH, 0, 1, ss);
  lcd_printf(3, 38, LCD_WIDTH, 0, 1, ss);
  
  return;
}

static void gobackground(void)
{
  int s;
  /* parent forks */
  s = fork();
  if (s < 0)
    {
      lcd_printf(0, 0, LCD_WIDTH, 0, 1, "Unable to Fork1: %s", strerror(errno));
    }
  else if (s > 0)
    {
      exit(0);
    }
  
  /* stdin   stdout    stderr */
  close(0); close(1); close(2);
  
  s = setsid();
  if (s < 0)
    {
      lcd_printf(0, 0, LCD_WIDTH, 0, 1, "Couldn't setsid: %s", strerror(errno));
    }
  
  /* parent forks */
  s = fork();
  if (s < 0)
    {
      lcd_printf(0, 0, LCD_WIDTH, 0, 1, "Unable to Fork1: %s", strerror(errno));
    }
  else if (s > 0)
    {
      /* parent exits */
      exit(0);
    }
  
  s = open("/dev/null", O_RDWR); /* stdin */
  dup(s);                        /* stdout */
  dup(s);                        /* stderr */
  
  return;
}


static void gotusr1 (int sig)
{
  needsredraw=1;
  signal(SIGUSR1,gotusr1);
  
  return;
}

static void gotusr2 (int sig)
{
  needsstat=1;
  signal(SIGUSR2,gotusr2);
  
  return;
}


/* end of file */

